/*
 * Decompiled with CFR 0.152.
 */
package net.adventurez.entity.model;

import com.google.common.collect.ImmutableList;
import net.adventurez.entity.BlackstoneGolemEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

@Environment(value=EnvType.CLIENT)
public class BlackstoneGolemModel<T extends BlackstoneGolemEntity>
extends ListModel<T> {
    private final ModelPart head;
    private final ModelPart torso;
    private final ModelPart rightArm;
    private final ModelPart leftArm;
    private final ModelPart rightLeg;
    private final ModelPart leftLeg;

    public BlackstoneGolemModel(ModelPart root) {
        this.head = root.m_171324_("head");
        this.torso = root.m_171324_("torso");
        this.rightArm = root.m_171324_("rightArm");
        this.leftArm = root.m_171324_("leftArm");
        this.rightLeg = root.m_171324_("rightLeg");
        this.leftLeg = root.m_171324_("leftLeg");
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.m_171576_();
        modelPartData.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-4.0f, -7.0f, -5.6225f, 8.0f, 10.0f, 8.0f).m_171514_(24, 0).m_171481_(-1.0f, -0.0f, -7.6225f, 2.0f, 4.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)2.5846f, (float)-7.1554f));
        modelPartData.m_171599_("torso", CubeListBuilder.m_171558_().m_171514_(0, 40).m_171481_(-9.0f, -1.2929f, -8.1213f, 18.0f, 12.0f, 11.0f).m_171514_(0, 70).m_171481_(-4.5f, 10.7071f, -5.1213f, 9.0f, 5.0f, 6.0f).m_171514_(42, 55).m_171481_(-1.0f, 1.0f, 3.0f, 7.0f, 6.0f, 1.0f).m_171514_(12, 57).m_171481_(-1.0f, 6.0f, -9.0f, 8.0f, 3.0f, 1.0f).m_171514_(28, 55).m_171481_(-8.0f, 3.0f, -9.0f, 6.0f, 2.0f, 1.0f).m_171514_(9, 56).m_171481_(-6.0f, 5.0f, 3.0f, 3.0f, 4.0f, 1.0f).m_171514_(33, 49).m_171481_(-10.0f, 5.0f, -5.0f, 1.0f, 4.0f, 6.0f).m_171514_(16, 54).m_171481_(9.0f, 6.0f, -4.0f, 1.0f, 4.0f, 3.0f), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)-1.0f));
        modelPartData.m_171599_("rightArm", CubeListBuilder.m_171558_().m_171514_(60, 21).m_171481_(-2.0f, -2.5f, -3.0f, 4.0f, 30.0f, 6.0f).m_171514_(62, 29).m_171481_(2.0f, 2.4378f, -1.4019f, 1.0f, 9.0f, 2.0f).m_171514_(66, 47).m_171481_(2.0f, 19.5981f, 0.768f, 1.0f, 4.0f, 1.0f).m_171514_(61, 46).m_171481_(-3.0f, 18.4378f, -1.9019f, 1.0f, 9.0f, 2.0f), PartPose.m_171419_((float)11.0f, (float)0.0f, (float)-3.0f));
        modelPartData.m_171599_("leftArm", CubeListBuilder.m_171558_().m_171514_(60, 58).m_171481_(-2.0f, -2.5f, -3.0f, 4.0f, 30.0f, 6.0f).m_171514_(70, 65).m_171481_(-3.0f, 4.4378f, -0.4019f, 1.0f, 9.0f, 2.0f).m_171514_(69, 85).m_171481_(-3.0f, 20.4378f, -0.9019f, 1.0f, 4.0f, 1.0f).m_171514_(60, 80).m_171481_(2.0f, 18.4378f, -1.9019f, 1.0f, 5.0f, 2.0f), PartPose.m_171419_((float)-11.0f, (float)0.0f, (float)-3.0f));
        modelPartData.m_171599_("rightLeg", CubeListBuilder.m_171558_().m_171514_(37, 0).m_171481_(1.5f, -0.6233f, -2.5578f, 6.0f, 16.0f, 5.0f), PartPose.m_171419_((float)0.0f, (float)10.0f, (float)9.0f));
        modelPartData.m_171599_("leftLeg", CubeListBuilder.m_171558_().m_171514_(60, 0).m_171481_(-7.5f, -0.6233f, -2.5578f, 6.0f, 16.0f, 5.0f), PartPose.m_171419_((float)0.0f, (float)10.0f, (float)9.0f));
        return LayerDefinition.m_171565_((MeshDefinition)modelData, (int)128, (int)128);
    }

    public Iterable<ModelPart> m_6195_() {
        return ImmutableList.of((Object)this.head, (Object)this.torso, (Object)this.rightLeg, (Object)this.leftLeg, (Object)this.rightArm, (Object)this.leftArm);
    }

    public void setAngles(T stoneGolem, float f, float g, float h, float i, float j) {
        float k;
        int roarTick = ((BlackstoneGolemEntity)((Object)stoneGolem)).getRoarTick();
        this.head.f_104204_ = i * 0.0077453293f;
        this.head.f_104203_ = j * 0.0017453292f + 0.2618f;
        this.rightLeg.f_104204_ = 0.0f;
        this.leftLeg.f_104204_ = 0.0f;
        this.rightLeg.f_104203_ = -0.3f * Mth.m_14156_((float)f, (float)13.0f) * g + 0.1745f;
        this.leftLeg.f_104203_ = 0.3f * Mth.m_14156_((float)f, (float)13.0f) * g + 0.1745f;
        this.torso.f_104203_ = 0.7854f;
        this.rightArm.f_104203_ = 0.5f * Mth.m_14156_((float)f, (float)13.0f) * g - 0.5236f;
        this.leftArm.f_104203_ = -0.5f * Mth.m_14156_((float)f, (float)13.0f) * g - 0.5236f;
        int thrownRockTick = (Integer)stoneGolem.m_20088_().m_135370_(BlackstoneGolemEntity.THROW_COOLDOWN);
        if (thrownRockTick >= 100) {
            this.leftArm.f_104203_ = Mth.m_14089_((float)((float)(-thrownRockTick) * 0.2f + 0.3f)) - 0.3f;
        }
        if (roarTick > 18) {
            this.rightArm.f_104203_ = Mth.m_14031_((float)((float)roarTick / 5.832f)) - 0.5236f;
            this.leftArm.f_104203_ = Mth.m_14031_((float)((float)roarTick / 5.832f)) - 0.5236f;
        }
        if ((k = Mth.m_14031_((float)(this.f_102608_ * (float)Math.PI)) * 0.5f) > 0.1f) {
            this.rightArm.f_104203_ = -k - 0.5236f;
        }
    }
}

